//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
struct st_Reg
{
    //+----------------+
    private:
    //+----------------+
        string  h_value;
        uint    k_value;
    //+----------------+
    public:
    //+----------------+
        void Set(const uint arg1, const string arg2)
        {
            k_value = arg1;
            h_value = arg2;
        }
    //+----------------+
        uint Get_K(void)    { return k_value; }
    //+----------------+
        string Get_H(void)  { return h_value; }
    //+----------------+
};
//+------------------------------------------------------------------+
struct st_Bio
{
    //+----------------+
    private:
    //+----------------+
        string  h_value;
        string  b_value;
        uint    k_value;
    //+----------------+
    public:
    //+----------------+
        void Set(const uint arg1, const string arg2, const string arg3)
        {
            k_value = arg1;
            h_value = arg2;
            b_value = arg3;
        }
    //+----------------+
        uint Get_K(void)    { return k_value; }
    //+----------------+
        bool Get_Bio(string &arg1, string &arg2)
        {
            arg1 = h_value;
            arg2 = b_value;

            return true;
        }
    //+----------------+
};
//+------------------------------------------------------------------+
template <typename T>
struct st_Data
{
    //+----------------+
    private:
    //+----------------+
        T Values[];
    //+----------------+
    public:
    //+----------------+
        bool Set(const T &arg)
        {
            if (ArrayResize(Values, Values.Size() + (Values.Size() == 0 ? 2 : 1)) == INVALID_HANDLE)
                return false;

            Values[Values.Size() - 1] = arg;

            return true;
        }
    //+----------------+
        T Get(const uint index)
        {
            for (uint c = 0; c < Values.Size(); c++)
                if (Values[c].Get_K() == index)
                    return Values[c];

            return Values[0];
        }
    //+----------------+
};
//+------------------------------------------------------------------+
#define PrintX(X) Print(#X, " => [", X, "]")
//+------------------------------------------------------------------+
void CheckBio(st_Data <st_Bio> &arg)
{
    string sz[2];

    Print("Checking data in the structure...");
    for (uint i = 7; i < 11; i += 3)
    {
        Print("Index: ", i, " Result: ");
        if (arg.Get(i).Get_Bio(sz[0], sz[1]))
            ArrayPrint(sz);
        else
            Print("Failed.");
    }
}
//+------------------------------------------------------------------+
void OnStart(void)
{
    const string T = "possible loss of data due to type conversion";
    const string M[] = {"2", "cool", "4", "zero", "mad", "five", "what", "xoxo"};
    const uint   K[] = {2, 1, 4, 0, 7, 5, 3, 6};

    st_Data <st_Reg> Info_1;
    st_Data <st_Bio> Info_2;

    string  H[];

    StringSplit(T, ' ', H);
    for (uint c = 0; c < H.Size(); c++)
    {
        st_Reg  reg;
        st_Bio  bio;

        reg.Set(K[c], H[c]);
        bio.Set(K[c], M[c], H[c]);

        Info_1.Set(reg);
        Info_2.Set(bio);
    }

    PrintX(Info_1.Get(3).Get_H());
    PrintX(Info_1.Get(13).Get_H());
    CheckBio(Info_2);
}
//+------------------------------------------------------------------+